<?php
/*
*  @author Comevents (Adrien)
*/
class ProductController extends ProductControllerCore
{  
  
  // On surcharge la fonction initContent pour pouvoir envoyer à la vue les produits similaires
  public function initContent(){
    // Ajout du temps restant au produit
    $today = new DateTime(); // Maintenant
    
    // print '<pre>'; print_r($this->product->specificPrice); print '</pre>';die(); // DEBUG
    
    $fin_flash  = new DateTime($this->product->specificPrice[to]); // Moment de la fin de la vente flash
    $tps_restant = $fin_flash->diff($today);

    // Stock séparemment le temps restant en jour, heure,minute,seconde pour les traiter dans le javascript de la vue
    $tab_tps_restant = array();
    $tab_tps_restant['jour'] = $tps_restant->format('%d');
    $tab_tps_restant['heure'] = $tps_restant->format('%h');
    $tab_tps_restant['minute'] = $tps_restant->format('%i');
    $tab_tps_restant['seconde'] = $tps_restant->format('%s');

    
    $this->context->smarty->assign(array(
        'tabtpsrestant'  =>  $tab_tps_restant,
        'similars' => $this->product->getSimilar($this->context->language->id),
        'substitutions' => $this->product->getSubstitution($this->context->language->id),
    ));
    
    parent::initContent();
  }
  
}
