<?php
/*
*  @author Comevents (Adrien)
*  Surcharge du controller d'administration afin d'y ajouter des actions groupées
* 
* @info Pour ajouter une action groupé il faut l'ajouter dans les fonctions renderList et initProcess (ex: ligne 44: 'promotionSelection' => array(... )
* @info Le code lié à l'action groupé doit être créer sous forme de fonction (ex: protected function processBulkPromotionSelection()) 
*/
class AdminController extends AdminControllerCore
{
  public function __construct()
  {
    parent::__construct();
	}
  
  /**
	 * Surcharge de la fonction afin d'y ajouter l'action groupé "Mettre fin aux promotions de la sélection"
	 */
	public function renderList()
	{
		if (!($this->fields_list && is_array($this->fields_list)))
			return false;
		$this->getList($this->context->language->id);

		// If list has 'active' field, we automatically create bulk action
		if (isset($this->fields_list) && is_array($this->fields_list) && array_key_exists('active', $this->fields_list)
			&& !empty($this->fields_list['active']))
		{
			if (!is_array($this->bulk_actions))
				$this->bulk_actions = array();

			$this->bulk_actions = array_merge(array(
				'enableSelection' => array(
					'text' => $this->l('Enable selection'),
					'icon' => 'icon-power-off text-success'
				),
				'disableSelection' => array(
					'text' => $this->l('Disable selection'),
					'icon' => 'icon-power-off text-danger'
				),
				'divider' => array(
					'text' => 'divider'
				),
        'promotionSelection' => array(
					'class' => 'test',
					'text' => $this->l('Mettre fin aux promotions de la sélection'),
					'icon' => 'icon-dollar text-danger'
				),
				'divider' => array(
					'text' => 'divider'
				)
			), $this->bulk_actions);
		}

		$helper = new HelperList();
		
		// Empty list is ok
		if (!is_array($this->_list))
		{
			$this->displayWarning($this->l('Bad SQL query', 'Helper').'<br />'.htmlspecialchars($this->_list_error));
			return false;
		}

		$this->setHelperDisplay($helper);
		$helper->tpl_vars = $this->tpl_list_vars;
		$helper->tpl_delete_link_vars = $this->tpl_delete_link_vars;

		// For compatibility reasons, we have to check standard actions in class attributes
		foreach ($this->actions_available as $action)
		{
			if (!in_array($action, $this->actions) && isset($this->$action) && $this->$action)
				$this->actions[] = $action;
		}
		$helper->is_cms = $this->is_cms;
		$list = $helper->generateList($this->_list, $this->fields_list);

		return $list;
	}
  
  /**
	 * Cette fonction n'est surchargé que pour ajouter le promotionSelection
	 */
	public function initProcess()
	{
		if (!isset($this->list_id))
			$this->list_id = $this->table;

		// Manage list filtering
		if (Tools::isSubmit('submitFilter'.$this->list_id) 
			|| $this->context->cookie->{'submitFilter'.$this->list_id} !== false
			|| Tools::getValue($this->list_id.'Orderby')
			|| Tools::getValue($this->list_id.'Orderway'))
			$this->filter = true;

		$this->id_object = (int)Tools::getValue($this->identifier);

		/* Delete object image */
		if (isset($_GET['deleteImage']))
		{
			if ($this->tabAccess['delete'] === '1')
				$this->action = 'delete_image';
			else
				$this->errors[] = Tools::displayError('You do not have permission to delete this.');
		}
		/* Delete object */
		elseif (isset($_GET['delete'.$this->table]))
		{
			if ($this->tabAccess['delete'] === '1')
				$this->action = 'delete';
			else
				$this->errors[] = Tools::displayError('You do not have permission to delete this.');
		}
		/* Change object statuts (active, inactive) */
		elseif ((isset($_GET['status'.$this->table]) || isset($_GET['status'])) && Tools::getValue($this->identifier))
		{
			if ($this->tabAccess['edit'] === '1')
				$this->action = 'status';
			else
				$this->errors[] = Tools::displayError('You do not have permission to edit this.');
		}
		/* Move an object */
		elseif (isset($_GET['position']))
		{
			if ($this->tabAccess['edit'] == '1')
				$this->action = 'position';
			else
				$this->errors[] = Tools::displayError('You do not have permission to edit this.');
		}
		elseif (Tools::isSubmit('submitAdd'.$this->table)
				 || Tools::isSubmit('submitAdd'.$this->table.'AndStay')
				 || Tools::isSubmit('submitAdd'.$this->table.'AndPreview')
				 || Tools::isSubmit('submitAdd'.$this->table.'AndBackToParent'))
		{
			// case 1: updating existing entry
			if ($this->id_object)
			{
				if ($this->tabAccess['edit'] === '1')
				{
					$this->action = 'save';
					if (Tools::isSubmit('submitAdd'.$this->table.'AndStay'))
						$this->display = 'edit';
					else
						$this->display = 'list';
				}
				else
					$this->errors[] = Tools::displayError('You do not have permission to edit this.');
			}
			// case 2: creating new entry
			else
			{
				if ($this->tabAccess['add'] === '1')
				{
					$this->action = 'save';
					if (Tools::isSubmit('submitAdd'.$this->table.'AndStay'))
						$this->display = 'edit';
					else
						$this->display = 'list';
				}
				else
					$this->errors[] = Tools::displayError('You do not have permission to add this.');
			}
		}
		elseif (isset($_GET['add'.$this->table]))
		{
			if ($this->tabAccess['add'] === '1')
			{
				$this->action = 'new';
				$this->display = 'add';
			}
			else
				$this->errors[] = Tools::displayError('You do not have permission to add this.');
		}
		elseif (isset($_GET['update'.$this->table]) && isset($_GET[$this->identifier]))
		{
			$this->display = 'edit';
			if ($this->tabAccess['edit'] !== '1')
				$this->errors[] = Tools::displayError('You do not have permission to edit this.');
		}
		elseif (isset($_GET['view'.$this->table]))
		{
			if ($this->tabAccess['view'] === '1')
			{
				$this->display = 'view';
				$this->action = 'view';
			}
			else
				$this->errors[] = Tools::displayError('You do not have permission to view this.');
		}
		elseif (isset($_GET['details'.$this->table]))
		{
			if ($this->tabAccess['view'] === '1')
			{
				$this->display = 'details';
				$this->action = 'details';
			}
			else
				$this->errors[] = Tools::displayError('You do not have permission to view this.');
		}
		elseif (isset($_GET['export'.$this->table]))
		{
			if ($this->tabAccess['view'] === '1')
				$this->action = 'export';
		}
		/* Cancel all filters for this tab */
		elseif (isset($_POST['submitReset'.$this->list_id]))
			$this->action = 'reset_filters';
		/* Submit options list */
		elseif (Tools::isSubmit('submitOptions'.$this->table) || Tools::isSubmit('submitOptions'))
		{
			$this->display = 'options';
			if ($this->tabAccess['edit'] === '1')
				$this->action = 'update_options';
			else
				$this->errors[] = Tools::displayError('You do not have permission to edit this.');
		}
		elseif (Tools::getValue('action') && method_exists($this, 'process'.ucfirst(Tools::toCamelCase(Tools::getValue('action')))))
			$this->action = Tools::getValue('action');
		elseif (Tools::isSubmit('submitFields') && $this->required_database && $this->tabAccess['add'] === '1' && $this->tabAccess['delete'] === '1')
			$this->action = 'update_fields';
		elseif (is_array($this->bulk_actions))
		{
			$submit_bulk_actions = array_merge(array(
				'enableSelection' => array(
					'text' => $this->l('Enable selection'),
					'icon' => 'icon-power-off text-success'
				),
				'disableSelection' => array(
					'text' => $this->l('Disable selection'),
					'icon' => 'icon-power-off text-danger'
				),
        'setPromotionSelection' => array(
					'text' => $this->l('Définir une promotion pour la sélection'),
					'icon' => 'icon-dollar text-success'
				),
        'divider' => array(
					'text' => 'divider'
				),
        'promotionSelection' => array(
					'text' => $this->l('Mettre fin aux promotions de la sélection'),
					'icon' => 'icon-dollar text-danger'
				)
			), $this->bulk_actions);
			foreach ($submit_bulk_actions as $bulk_action => $params)
			{
				if (Tools::isSubmit('submitBulk'.$bulk_action.$this->table) || Tools::isSubmit('submitBulk'.$bulk_action))
				{
					if ($this->tabAccess['edit'] === '1')
					{
						$this->action = 'bulk'.$bulk_action;
						$this->boxes = Tools::getValue($this->table.'Box');
					}
					else
						$this->errors[] = Tools::displayError('You do not have permission to edit this.');
					break;
				}
				elseif (Tools::isSubmit('submitBulk'))
				{
					if ($this->tabAccess['edit'] === '1')
					{
						$this->action = 'bulk'.Tools::getValue('select_submitBulk');
						$this->boxes = Tools::getValue($this->table.'Box');
					}
					else
						$this->errors[] = Tools::displayError('You do not have permission to edit this.');
					break;
				}
			}
		}
		elseif (!empty($this->fields_options) && empty($this->fields_list))
			$this->display = 'options';
	}
  
  /**
   * Désactivation des promotions sur les articles sélectionnnés
   */
  protected function processBulkPromotionSelection()
	{
		$result = true;
		if (is_array($this->boxes) && !empty($this->boxes))
		{
			foreach ($this->boxes as $id)
			{
				$object = new $this->className((int)$id);
        //echo '<pre>';  print_r($object ); echo '</pre>'; die('fin test dans processBulkPromotionSelection (AdminController)'); // DEBUG
        
        // Pour supprimer une promotion il y a deux étapes:
        // 1. Signaler que le produit n'est plus en vente flash 
				$object->vente_flash = 0;
				$result &= $object->update();
        
        // 2. Supprimer le prix spécifique
        SpecificPrice::deleteByProductId((int)$object->id);
			}
		}
		return $result;
	}
    
}
