<?php
/*
*  @author Comevents (Adrien)
 * @todo réparer faille avec le GET, un utilisateur peut pas passer sa commande en paiement accepté
*/

class PaiementnfoisPaiementnaccepteModuleFrontController extends ModuleFrontController
{
	public function postProcess()
	{
    // Récupération de la commande à partir de la référence (on part d'une principe qu'un référence est unique)
    $orders = Order::getByReference($_GET['ref']);
    $order = $orders[0];
    $customer = new Customer($orders[0]->id_customer);
    
    // Si le paiement est accepté et que l'utilisateur connecté est celui de la commande
    if($_GET['controller'] == 'paiementnaccepte' && $this->context->customer->id==$customer->id){
      
      // Le paiement étant accepté, on met à jour l'état de la commande en "paiement accepté"
      $history = new OrderHistory();
      $history->id_order = (int)$order->id;
      $history->changeIdOrderState(2, (int)($order->id)); //order status=2 -> Paiement accepté
      $history->add(true); // Ajout dans l'historique (sinon les paiements reste en attente)
      
      $this->envoieMailCorfirmation($order);
      
      // Envoie des données au template
      $this->context->smarty->assign(array(
        'montant' => $_GET['montant'],
        'ref' => $_GET['ref'],
        'module' => $_GET['module'],
        'trans' => $_GET['trans'],
        'ref' => $_GET['ref'],
        'this_path' => $this->module->getPathUri(),
        'this_path_paiementnfois' => $this->module->getPathUri(),
        'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/'
      ));

      $this->setTemplate('paiementn_accepte.tpl');
    }
    else{
      die('Accès interdit');
    }
	}
  
  public function envoieMailCorfirmation($order){
    // Récupération des données pour le mail
          
      // Récupération des produits de la commande
      $virtual_product = true;
      $product_var_tpl_list = array();      
      $products = $order->getProductsDetail(); // Listes des produits de cette commande (remplace le order->products_list)
      
      foreach ($products as $product)
      {
        $price = Product::getPriceStatic((int)$product['id_product'], false, ($product['id_product_attribute'] ? (int)$product['id_product_attribute'] : null), 6, null, false, true, $product['cart_quantity'], false, (int)$order->id_customer, (int)$order->id_cart, (int)$order->{Configuration::get('PS_TAX_ADDRESS_TYPE')});
        $price_wt = Product::getPriceStatic((int)$product['id_product'], true, ($product['id_product_attribute'] ? (int)$product['id_product_attribute'] : null), 2, null, false, true, $product['cart_quantity'], false, (int)$order->id_customer, (int)$order->id_cart, (int)$order->{Configuration::get('PS_TAX_ADDRESS_TYPE')});

        $product_price = Product::getTaxCalculationMethod() == PS_TAX_EXC ? Tools::ps_round($price, 2) : $price_wt;

        $product_var_tpl = array(
          'reference' => $product['reference'],
          'name' => $product['product_name'].(isset($product['attributes']) ? ' - '.$product['attributes'] : ''),
          'unit_price' => Tools::displayPrice($product_price, $this->context->currency, false),
          'price' => Tools::displayPrice($product_price * $product['quantity'], $this->context->currency, false),
          'quantity' => $product['quantity'],
          'customization' => array()
        );
        
        $customized_datas = Product::getAllCustomizedDatas((int)$order->id_cart);
        if (isset($customized_datas[$product['id_product']][$product['id_product_attribute']]))
        {
          $product_var_tpl['customization'] = array();
          foreach ($customized_datas[$product['id_product']][$product['id_product_attribute']][$order->id_address_delivery] as $customization)
          {
            $customization_text = '';
            if (isset($customization['datas'][Product::CUSTOMIZE_TEXTFIELD]))
              foreach ($customization['datas'][Product::CUSTOMIZE_TEXTFIELD] as $text)
                $customization_text .= $text['name'].': '.$text['value'].'<br />';

            if (isset($customization['datas'][Product::CUSTOMIZE_FILE]))
              $customization_text .= sprintf(Tools::displayError('%d image(s)'), count($customization['datas'][Product::CUSTOMIZE_FILE])).'<br />';

            $customization_quantity = (int)$product['customization_quantity'];

            $product_var_tpl['customization'][] = array(
              'customization_text' => $customization_text,
              'customization_quantity' => $customization_quantity,
              'quantity' => Tools::displayPrice($customization_quantity * $product_price, $this->context->currency, false)
            );
          }
        }

        $product_var_tpl_list[] = $product_var_tpl;
        // Check if is not a virutal product for the displaying of shipping
        if (!$product['is_virtual'])
          $virtual_product &= false;

      } // end foreach ($products)

      $product_list_txt = '';
      $product_list_html = '';
      if (count($product_var_tpl_list) > 0)
      {
        $product_list_txt = $this->getEmailTemplateContent('order_conf_product_list.txt', Mail::TYPE_TEXT, $product_var_tpl_list);
        $product_list_html = $this->getEmailTemplateContent('order_conf_product_list.tpl', Mail::TYPE_HTML, $product_var_tpl_list);
      }
      // FIN Récupération des produits de la commande
      
      // Récupération des promotions
      CartRule::cleanCache();
			$cart_rules = $this->context->cart->getCartRules();
      $cart_rules_list = array();
      $total_reduction_value_ti = 0;
      $total_reduction_value_tex = 0;
      foreach ($cart_rules as $cart_rule)
      {
        $package = array('id_carrier' => $order->id_carrier, 'id_address' => $order->id_address_delivery, 'products' => $order->product_list);
        $values = array(
          'tax_incl' => $cart_rule['obj']->getContextualValue(true, $this->context, CartRule::FILTER_ACTION_ALL_NOCAP, $package),
          'tax_excl' => $cart_rule['obj']->getContextualValue(false, $this->context, CartRule::FILTER_ACTION_ALL_NOCAP, $package)
        );

        // If the reduction is not applicable to this order, then continue with the next one
        if (!$values['tax_excl'])
          continue;
        
        if (count($order_list) == 1 && $values['tax_incl'] > ($order->total_products_wt - $total_reduction_value_ti) && $cart_rule['obj']->partial_use == 1 && $cart_rule['obj']->reduction_amount > 0)
        {
          // Create a new voucher from the original
          $voucher = new CartRule($cart_rule['obj']->id); // We need to instantiate the CartRule without lang parameter to allow saving it
          unset($voucher->id);

          // Set a new voucher code
          $voucher->code = empty($voucher->code) ? substr(md5($order->id.'-'.$order->id_customer.'-'.$cart_rule['obj']->id), 0, 16) : $voucher->code.'-2';
          if (preg_match('/\-([0-9]{1,2})\-([0-9]{1,2})$/', $voucher->code, $matches) && $matches[1] == $matches[2])
            $voucher->code = preg_replace('/'.$matches[0].'$/', '-'.(intval($matches[1]) + 1), $voucher->code);

          // Set the new voucher value
          if ($voucher->reduction_tax)
          {
            $voucher->reduction_amount = $values['tax_incl'] - ($order->total_products_wt - $total_reduction_value_ti);

            // Add total shipping amout only if reduction amount > total shipping
            if ($voucher->free_shipping == 1 && $voucher->reduction_amount >= $order->total_shipping_tax_incl)
              $voucher->reduction_amount -= $order->total_shipping_tax_incl;
          }
          else
          {
            $voucher->reduction_amount = $values['tax_excl'] - ($order->total_products - $total_reduction_value_tex);

            // Add total shipping amout only if reduction amount > total shipping
            if ($voucher->free_shipping == 1 && $voucher->reduction_amount >= $order->total_shipping_tax_excl)
              $voucher->reduction_amount -= $order->total_shipping_tax_excl;
          }

          $voucher->id_customer = $order->id_customer;
          $voucher->quantity = 1;
          $voucher->quantity_per_user = 1;
          $voucher->free_shipping = 0;
          if ($voucher->add())
          {
            // If the voucher has conditions, they are now copied to the new voucher
            CartRule::copyConditions($cart_rule['obj']->id, $voucher->id);

            $params = array(
              '{voucher_amount}' => Tools::displayPrice($voucher->reduction_amount, $this->context->currency, false),
              '{voucher_num}' => $voucher->code,
              '{firstname}' => $this->context->customer->firstname,
              '{lastname}' => $this->context->customer->lastname,
              '{id_order}' => $order->reference,
              '{order_name}' => $order->getUniqReference()
            );
            Mail::Send(
              (int)$order->id_lang,
              'voucher',
              sprintf(Mail::l('New voucher regarding your order %s', (int)$order->id_lang), $order->reference),
              $params,
              $this->context->customer->email,
              $this->context->customer->firstname.' '.$this->context->customer->lastname,
              null, null, null, null, _PS_MAIL_DIR_, false, (int)$order->id_shop
            );
          }

          $values['tax_incl'] -= $values['tax_incl'] - $order->total_products_wt;
          $values['tax_excl'] -= $values['tax_excl'] - $order->total_products;

        }
        $total_reduction_value_ti += $values['tax_incl'];
        $total_reduction_value_tex += $values['tax_excl'];

        $order->addCartRule($cart_rule['obj']->id, $cart_rule['obj']->name, $values, 0, $cart_rule['obj']->free_shipping);

        if ($id_order_state != Configuration::get('PS_OS_ERROR') && $id_order_state != Configuration::get('PS_OS_CANCELED') && !in_array($cart_rule['obj']->id, $cart_rule_used))
        {
          $cart_rule_used[] = $cart_rule['obj']->id;

          // Create a new instance of Cart Rule without id_lang, in order to update its quantity
          $cart_rule_to_update = new CartRule($cart_rule['obj']->id);
          $cart_rule_to_update->quantity = max(0, $cart_rule_to_update->quantity - 1);
          $cart_rule_to_update->update();
        }

        $cart_rules_list[] = array(
          'voucher_name' => $cart_rule['obj']->name,
          'voucher_reduction' => ($values['tax_incl'] != 0.00 ? '-' : '').Tools::displayPrice($values['tax_incl'], $this->context->currency, false)
        );
      }

      $cart_rules_list_txt = '';
      $cart_rules_list_html = '';
      if (count($cart_rules_list) > 0)
      {
        $cart_rules_list_txt = $this->getEmailTemplateContent('order_conf_cart_rules.txt', Mail::TYPE_TEXT, $cart_rules_list);
        $cart_rules_list_html = $this->getEmailTemplateContent('order_conf_cart_rules.tpl', Mail::TYPE_HTML, $cart_rules_list);
      }
      // FIN Récupération des promotions
      
      // Récupération des adresses (client + livraison
      $invoice = new Address($order->id_address_invoice);
      $delivery = new Address($order->id_address_delivery);
      $delivery_state = $delivery->id_state ? new State($delivery->id_state) : false;
      $invoice_state = $invoice->id_state ? new State($invoice->id_state) : false;
      
      // On regroupe toutes les données dans un tableau $data
      $data = array(
        '{firstname}' => $this->context->customer->firstname,
        '{lastname}' => $this->context->customer->lastname,
        '{email}' => $this->context->customer->email,
        '{delivery_block_txt}' => $this->_getFormatedAddress($delivery, "\n"),
        '{invoice_block_txt}' => $this->_getFormatedAddress($invoice, "\n"),
        '{delivery_block_html}' => $this->_getFormatedAddress($delivery, '<br />', array(
          'firstname'	=> '<span style="font-weight:bold;">%s</span>',
          'lastname'	=> '<span style="font-weight:bold;">%s</span>'
        )),
        '{invoice_block_html}' => $this->_getFormatedAddress($invoice, '<br />', array(
            'firstname'	=> '<span style="font-weight:bold;">%s</span>',
            'lastname'	=> '<span style="font-weight:bold;">%s</span>'
        )),
        '{delivery_company}' => $delivery->company,
        '{delivery_firstname}' => $delivery->firstname,
        '{delivery_lastname}' => $delivery->lastname,
        '{delivery_address1}' => $delivery->address1,
        '{delivery_address2}' => $delivery->address2,
        '{delivery_city}' => $delivery->city,
        '{delivery_postal_code}' => $delivery->postcode,
        '{delivery_country}' => $delivery->country,
        '{delivery_state}' => $delivery->id_state ? $delivery_state->name : '',
        '{delivery_phone}' => ($delivery->phone) ? $delivery->phone : $delivery->phone_mobile,
        '{delivery_other}' => $delivery->other,
        '{invoice_company}' => $invoice->company,
        '{invoice_vat_number}' => $invoice->vat_number,
        '{invoice_firstname}' => $invoice->firstname,
        '{invoice_lastname}' => $invoice->lastname,
        '{invoice_address2}' => $invoice->address2,
        '{invoice_address1}' => $invoice->address1,
        '{invoice_city}' => $invoice->city,
        '{invoice_postal_code}' => $invoice->postcode,
        '{invoice_country}' => $invoice->country,
        '{invoice_state}' => $invoice->id_state ? $invoice_state->name : '',
        '{invoice_phone}' => ($invoice->phone) ? $invoice->phone : $invoice->phone_mobile,
        '{invoice_other}' => $invoice->other,
        '{order_name}' => $order->getUniqReference(),
        '{date}' => Tools::displayDate(date('Y-m-d H:i:s'), null, 1),
        '{carrier}' => ($virtual_product || !isset($carrier->name)) ? Tools::displayError('No carrier') : $carrier->name,
        '{payment}' => Tools::substr($order->payment, 0, 32),
        '{products}' => $product_list_html,
        '{products_txt}' => $product_list_txt,
        '{discounts}' => $cart_rules_list_html,
        '{discounts_txt}' => $cart_rules_list_txt,
        '{total_paid}' => Tools::displayPrice($order->total_paid, $this->context->currency, false),
        '{total_products}' => Tools::displayPrice($order->total_paid - $order->total_shipping - $order->total_wrapping + $order->total_discounts, $this->context->currency, false),
        '{total_discounts}' => Tools::displayPrice($order->total_discounts, $this->context->currency, false),
        '{total_shipping}' => Tools::displayPrice($order->total_shipping, $this->context->currency, false),
        '{total_wrapping}' => Tools::displayPrice($order->total_wrapping, $this->context->currency, false),
        '{total_tax_paid}' => Tools::displayPrice(($order->total_products_wt - $order->total_products) + ($order->total_shipping_tax_incl - $order->total_shipping_tax_excl), $this->context->currency, false)
      );
      
      // Envoie du mail
      Mail::Send(
        (int)$order->id_lang,
        'order_conf',
        Mail::l('Order confirmation', (int)$order->id_lang),
        $data,
        $this->context->customer->email,
        $this->context->customer->firstname.' '.$this->context->customer->lastname,
        null,
        null,
        null,
        null, _PS_MAIL_DIR_, false, (int)$order->id_shop
      );
  }
  
  protected function getEmailTemplateContent($template_name, $mail_type, $var)                                    
  {                                    
      $email_configuration = Configuration::get('PS_MAIL_TYPE');                                
      if ($email_configuration != $mail_type && $email_configuration != Mail::TYPE_BOTH)                                
          return '';                            

      $theme_template_path = _PS_THEME_DIR_.'mails'.DIRECTORY_SEPARATOR.$this->context->language->iso_code.DIRECTORY_SEPARATOR.$template_name;                                
      $default_mail_template_path = _PS_MAIL_DIR_.$this->context->language->iso_code.DIRECTORY_SEPARATOR.$template_name;                                

      if (Tools::file_exists_cache($theme_template_path))                                
          $default_mail_template_path = $theme_template_path;                            

      if (Tools::file_exists_cache($default_mail_template_path))                                
      {                                
          $this->context->smarty->assign('list', $var);                            
          return $this->context->smarty->fetch($default_mail_template_path);                            
      }                                
      return '';                                
  }     
  
  /*
   * reprise de la fonction dans PaymentModule.php
   */
	protected function _getFormatedAddress(Address $the_address, $line_sep, $fields_style = array())
	{
		return AddressFormat::generateAddress($the_address, array('avoid' => array()), $line_sep, ' ', $fields_style);
	}
}
