<?php
/*
*  @author Comevents (Adrien)
*/

if (!defined('_PS_VERSION_'))
	exit;

class BlockHomePromotions extends Module
{
	private $_html = '';
	private $_postErrors = array();

  function __construct()
  {
    $this->name = 'blockhomepromotions';
    $this->tab = 'pricing_promotion';
    $this->version = '1.1.1';
    $this->author = 'Comevents';
    $this->need_instance = 0;

    $this->bootstrap = true;
    parent::__construct();	

    $this->displayName = $this->l('Specials block');
    $this->description = $this->l('Adds a block displaying your current discounted products.');
    $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
  }

	public function install()
	{
		if (!Configuration::get('BLOCKHOMEPROMOTIONS_NB_CACHES'))
			Configuration::updateValue('BLOCKHOMEPROMOTIONS_NB_CACHES', 20);
		$this->_clearCache('blockhomepromotions.tpl');

		$success = (
			parent::install()
			&& $this->registerHook('header')
			&& $this->registerHook('addproduct')
			&& $this->registerHook('updateproduct')
			&& $this->registerHook('deleteproduct')
		);

		if ($success)
		{
			// Hook the module either on the left or right column
			$theme = new Theme(Context::getContext()->shop->id_theme);
			if ((!$theme->default_right_column || !$this->registerHook('rightColumn'))
				&& (!$theme->default_left_column || !$this->registerHook('leftColumn')))
			{
				// If there are no colums implemented by the template, throw an error and uninstall the module
				$this->_errors[] = $this->l('This module need to be hooked in a column and your theme does not implement one');
				parent::uninstall();
				return false;
			}
		}
		return $success;
	}
	
	public function uninstall()
	{
		$this->_clearCache('blockhomepromotions.tpl');
		return parent::uninstall();
	}

	public function getContent()
	{
		$output = '';
		if (Tools::isSubmit('submitSpecials'))
		{
			Configuration::updateValue('PS_BLOCK_HOMEPROMOTIONS_DISPLAY', (int)Tools::getValue('PS_BLOCK_HOMEPROMOTIONS_DISPLAY'));
			Configuration::updateValue('BLOCKHOMEPROMOTIONS_NB_CACHES', (int)Tools::getValue('BLOCKHOMEPROMOTIONS_NB_CACHES'));
			$output .= $this->displayConfirmation($this->l('Settings updated'));
		}
		return $output.$this->renderForm();
	}

	public function hookRightColumn($params)
	{
		if (Configuration::get('PS_CATALOG_MODE')) return;
    
    // NOMBRE DE PRODUITS A AFFICHER
    $nbr_product = Configuration::get('BLOCKHOMEPROMOTIONS_NB_CACHES');
    
    // Récupération de 2 identifiants au hasard dans les produits actuellement en promotion
    $sql = "SELECT il.*,pl.name, pl.link_rewrite, p.*, sp.id_product
            FROM ps_specific_price AS sp
            INNER JOIN ps_product AS p ON sp.id_product = p.id_product
            LEFT JOIN `ps_product_lang` pl ON (p.`id_product` = pl.`id_product`)
            LEFT JOIN `ps_image` i ON (i.`id_product` = p.`id_product`)
            LEFT JOIN `ps_image_lang` il ON (i.`id_image` = il.`id_image`)
            WHERE (sp.to > NOW() OR sp.to='0000-00-00')
            AND sp.from < NOW()
            AND p.vente_flash = 0
            AND p.active = 1
            ORDER BY RAND()
            LIMIT 0,".$nbr_product;

    global $cookie;
    $id_lang = $cookie->id_lang;

    $result = Db::getInstance()->executeS($sql);
    $specials = Product::getProductsProperties($id_lang, $result);
    
    // print '<pre>'; print_r($specials); print '</pre>';die();

    $this->smarty->assign(array(
      'specials' => $specials,
      'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
    ));

		return $this->display(__FILE__, 'blockhomepromotions.tpl');
	}
  
  
  public function hookdisplayHomeTabContent($params)
	{
		return $this->hookRightColumn($params);
	}
  
	
	public function hookHeader($params)
	{
		if (Configuration::get('PS_CATALOG_MODE'))
			return ;
		$this->context->controller->addCSS(($this->_path).'blockhomepromotions.css', 'all');
	}

	public function hookAddProduct($params)
	{
		$this->_clearCache('blockhomepromotions.tpl');
	}

	public function hookUpdateProduct($params)
	{
		$this->_clearCache('blockhomepromotions.tpl');
	}

	public function hookDeleteProduct($params)
	{
		$this->_clearCache('blockhomepromotions.tpl');
	}
	
	public function renderForm()
	{
		$fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Settings'),
					'icon' => 'icon-cogs'
				),
				'input' => array(
					array(
						'type' => 'switch',
						'label' => $this->l('Always display this block'),
						'name' => 'PS_BLOCK_HOMEPROMOTIONS_DISPLAY',
						'desc' => $this->l('Show the block even if no products are available.'),
						'values' => array(
									array(
										'id' => 'active_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'active_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
								),
					),
					array(
						'type' => 'text',
						'label' => $this->l('Number of cached files'),
						'name' => 'BLOCKHOMEPROMOTIONS_NB_CACHES',
						'desc' => $this->l('Specials are displayed randomly on the front-end, but since it takes a lot of ressources, it is better to cache the results. The cache is reset daily. 0 will disable the cache.'),
					),
				),
				'submit' => array(
					'title' => $this->l('Save'),
				)
			),
		);
		
		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table =  $this->table;
		$lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
		$helper->default_form_language = $lang->id;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submitSpecials';
		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues(),
			'languages' => $this->context->controller->getLanguages(),
			'id_language' => $this->context->language->id
		);

		return $helper->generateForm(array($fields_form));
	}
	
	public function getConfigFieldsValues()
	{
		return array(
			'PS_BLOCK_HOMEPROMOTIONS_DISPLAY' => Tools::getValue('PS_BLOCK_HOMEPROMOTIONS_DISPLAY', Configuration::get('PS_BLOCK_HOMEPROMOTIONS_DISPLAY')),
			'BLOCKHOMEPROMOTIONS_NB_CACHES' => Tools::getValue('BLOCKHOMEPROMOTIONS_NB_CACHES', Configuration::get('BLOCKHOMEPROMOTIONS_NB_CACHES')),
		);
	}
}
